/*
 * @(#)Clipboard.cpp 1.00 26 Sxeptember 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "misc/Clipboard.h"

#include "Application.h"
#include "misc/Streambuf.h"

#include "tse3/Phrase.h"
#include "tse3/Track.h"
#include "tse3/app/PartSelection.h"
#include "tse3/app/TrackSelection.h"

#include <qclipboard.h>

void toClipboard(TSE3::Track *track)
{
    QClipboard *clipboard = Application::application()->clipboard();
    if (track)
    {
        QString str("Track");
        clipboard->setText(str);
    }
    else
    {
        clipboard->clear();
    }
}


void toClipboard(TSE3::Part *part)
{
    QClipboard *clipboard = Application::application()->clipboard();
    if (part)
    {
        QString str;
        QStringOStream ostr(str);
        ostr << "Part\n";
        part->save(ostr, 0);
        clipboard->setText(str);
    }
    else
    {
        clipboard->clear();
    }
}


void toClipboard(TSE3::Phrase *phrase)
{
    QClipboard *clipboard = Application::application()->clipboard();
    if (phrase)
    {
        QString str;
        QStringOStream ostr(str);
        ostr << "Phrase\n";
        phrase->save(ostr, 0);
        clipboard->setText(str);
    }
    else
    {
        clipboard->clear();
    }
}


void toClipboard(TSE3::App::PartSelection *ps)
{
    QClipboard *clipboard = Application::application()->clipboard();
    QString str;
    QStringOStream ostr(str);
    TSE3::App::PartSelection::iterator_t i = ps->begin();
    while (i != ps->end())
    {
        ostr << "Part\n";
        (*i)->save(ostr, 0);
        i++;
    }
    clipboard->setText(str);
}


void toClipboard(TSE3::App::TrackSelection *ts)
{
    QClipboard *clipboard = Application::application()->clipboard();
    QString str;
    QStringOStream ostr(str);
    TSE3::App::TrackSelection::iterator_t i = ts->begin();
    while (i != ts->end())
    {
        ostr << "Track\n";
        (*i)->save(ostr, 0);
        i++;
    }
    clipboard->setText(str);
}


ClipboardData clipboardData()
{
    QClipboard *clipboard = Application::application()->clipboard();
    QString text = clipboard->text();
    if (text)
    {
        if (text.startsWith("Track"))
        {
            return Clipboard_Track;
        }
        else if (text.startsWith("Part"))
        {
            return Clipboard_Part;
        }
        else if (text.startsWith("Phrase"))
        {
            return Clipboard_Phrase;
        }
    }
    return Clipboard_None;
}


TSE3::Track *trackFromClipboard()
{
    TSE3::Track *track = new TSE3::Track();
    return track;
}


TSE3::Part *partFromClipboard()
{
    TSE3::Part *part = new TSE3::Part();
    return part;
}


#include "debug.cpp"
