/*
 * @(#)Clipboard.h 1.00 26 September 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_CLIPBOARD_H
#define ANTHEM_CLIPBOARD_H

namespace TSE3
{
    class Track;
    class Part;
    class Phrase;

    namespace App
    {
        class PartSelection;
        class TrackSelection;
    }
}

/**
 * Copies the specified @ref TSE3::Track to the clipboard.
 *
 * @param track @ref TSE3::Track to put on clipboard.
 */
void toClipboard(TSE3::Track *track);


/**
 * Copies the specified @ref TSE3::Part to the clipboard.
 *
 * @param part @ref TSE3::Part to put on clipboard.
 */
void toClipboard(TSE3::Part *part);


/**
 * Copies the specified @ref TSE3::Phrase to the clipboard.
 *
 * @param part @ref TSE3::Phrase to put on clipboard.
 */
void toClipboard(TSE3::Phrase *phrase);


/**
 * Copies the specified @ref TSE3::Part objects to the clipboard.
 *
 * @param parts @ref TSE3::App::PartSelection holding the Parts to put on
 *              clipboard.
 */
void toClipboard(TSE3::App::PartSelection *parts);


/**
 * Copies the specified @ref TSE3::Track objects to the clipboard.
 *
 * @param parts @ref TSE3::App::TrackSelection holding the Track to put on
 *              clipboard.
 */
void toClipboard(TSE3::App::TrackSelection *tracks);


/**
 * enum type describing the data on the @ref QClipboard that Anthem recognises.
 */
enum ClipboardData
{
    Clipboard_None,
    Clipboard_Track,
    Clipboard_Part,
    Clipboard_Phrase
};


/**
 * Returns the data type currently on the clipboard.
 *
 * @return Type of data on the clipboard
 */
ClipboardData clipboardData();


/**
 * Returns a new @ref TSE3::Track object created from data on the
 * @ref QClipboard.
 *
 * It has been created with new, and is your responsibility to delete.
 *
 * @return A new @ref TSE3::Track object
 */
TSE3::Track *trackFromClipboard();


/**
 * Returns a new @ref TSE3::Part object created from data on the
 * @ref QClipboard.
 *
 * It has been created with new, and is your responsibility to delete.
 *
 * @return A new @ref TSE3::Part object
 */
TSE3::Part *partFromClipboard();

#endif
