/*
 * @(#)PianoRollEditor.h 1.00 16 April 2002
 *
 * Copyright (c) Pete Goodliffe 2002 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_PIANOROLLEDITOR_H
#define ANTHEM_PIANOROLLEDITOR_H

#include "phraseeditors/PhraseEditor.h"

#include "tse3/Notifier.h"
#include "tse3/Midi.h"
#include "tse3/listen/PhraseEdit.h"

#include <kdialogbase.h>

class QSlider;
class QSpinBox;

class ClockWidget;
class KeyWidget;

/**
 * Internal implementation widget for the PianoRollEditor.
 *
 * @short   @ref TSE3::Phrase piano roll editor implementation window
 * @author  Pete Goodliffe
 * @version 1.0
 * @internal
 */
class PianoRollEditorImpl : public QScrollView,
                            public TSE3::Listener<TSE3::PhraseEditListener>
{
        Q_OBJECT;

    public:

        PianoRollEditorImpl(TSE3::PhraseEdit *phraseEdit, QWidget *parent);

        /**
         * @reimplemented
         */
        virtual void PhraseEdit_Reset(TSE3::PhraseEdit *);

        /**
         * @reimplemented
         */
        virtual void PhraseEdit_Tidied(TSE3::PhraseEdit *);

        /**
         * @reimplemented
         */
        virtual void PhraseEdit_Inserted(TSE3::PhraseEdit *, size_t index);

        /**
         * @reimplemented
         */
        virtual void PhraseEdit_Erased(TSE3::PhraseEdit *, size_t index);

        /**
         * @reimplemented
         */
        virtual void PhraseEdit_Selection(TSE3::PhraseEdit *, size_t index,
                                          bool selected);

    signals:

    private:

        TSE3::PhraseEdit *phraseEdit;
        class NoteDisplayWidget *ndw;
};

/**
 * A @ref TSE3::Phrase editor that plugs into the @ref PhraseEditor window.
 *
 * It displays events in a "piano roll".
 *
 * You do not create these directly, but create them via the @ref PhraseEditor
 * window.
 *
 * @short   @ref TSE3::Phrase paino roll editor window
 * @author  Pete Goodliffe
 * @version 1.0
 */
class PianoRollEditor : public PhraseEditorBase,
                        public TSE3::Listener<TSE3::PhraseEditListener>
{
        Q_OBJECT

    public:

        PianoRollEditor(TSE3::PhraseEdit *phraseEdit, KToolBar *toolbar,
                   QWidget *parent);
        virtual ~PianoRollEditor();

        /**
         * @reimplemented
         */
        virtual void PhraseEdit_Selection(TSE3::PhraseEdit *,
                                          size_t /*index*/,
                                          bool /*selected*/);

    private slots:

        void slotToolbarClicked(int);

    private:

        /**
         * Sets the status of the Toolbar_Delete button to reflect whether
         * or not any events are selected in the @ref TSE3::PhraseEdit.
         */
        void updateDeleteEnabled();

        enum Toolbar_Std { Toolbar_Something = PhraseEditor::Toolbar_NoButtons,
                           Toolbar_Delete };

        // UI widgets
        PianoRollEditorImpl *impl;

        TSE3::PhraseEdit *phraseEdit;
};

#endif
