/*
 * @(#)Application.cpp 1.00 1 December 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "settings/App.h"

#include "Application.h"

#include <qcheckbox.h>
#include <qlayout.h>

#include <kdialogbase.h>

#include "Application.h"

/******************************************************************************
 * ApplicationWidget class
 *****************************************************************************/

ApplicationWidget::ApplicationWidget(QWidget *parent, const char *name)
: SettingsWidget(0, parent, name)
{
    QVBoxLayout *layout = new QVBoxLayout(this, KDialogBase::spacingHint());

    // Title
    save = new QCheckBox("Save choices on exit", this);
    layout->addWidget(save);

    layout->addStretch(10);

    updateWidgets();
}


ApplicationWidget::~ApplicationWidget()
{
}


void ApplicationWidget::setValues()
{
    Application::application()->setSaveChoicesOnDestroy(save->isChecked());
}


void ApplicationWidget::updateWidgets()
{
    save->setChecked(Application::application()->saveChoicesOnDestroy());
}

