/*
 * @(#)DisplayParams.cpp 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "settings/DisplayParams.h"

#include "Application.h"
#include "gadgets/DPColourWidget.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qcheckbox.h>

#include <kdialogbase.h>
#include <kcolorbtn.h>

#include "tse3/DisplayParams.h"

/******************************************************************************
 * DisplayParamsWidget class
 *****************************************************************************/

DisplayParamsWidget::DisplayParamsWidget(TSE3::DisplayParams *dp, bool u,
                                         QWidget *parent, const char *name)
: SettingsWidget
    (new SettingsImpl<TSE3::DisplayParamsListener>(dp), parent, name),
  dp(dp)
{
    QVBoxLayout *layout = new QVBoxLayout(this, KDialogBase::spacingHint(), -1);
    QGridLayout *gl = new QGridLayout(layout, 1, 2);

    // Colour
    QLabel *label = new QLabel("Colour", this);
    label->setAlignment(AlignRight|AlignVCenter);
    label->setMaximumWidth(label->width());
    gl->addWidget(label, 0, 0);
    colour = new DPColourWidget(dp, u, this);
    gl->addWidget(colour, 0, 1);

    layout->addStretch(1);
    updateWidgets();
}


DisplayParamsWidget::~DisplayParamsWidget()
{
}


void DisplayParamsWidget::setValues()
{
    setValues(*dp);
}


void DisplayParamsWidget::updateWidgets()
{
    colour->valuesFrom(dp);
}


void DisplayParamsWidget::setValues(TSE3::DisplayParams &dp)
{
    colour->valuesTo(&dp);
}

