/*
 * @(#)DisplayParams.h 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_SETTINGS_DISPLAYPARAMS_H
#define ANTHEM_SETTINGS_DISPLAYPARAMS_H

#include "settings/SettingsWidget.h"

class QCheckBox;
class KColorButton;

class DPColourWidget;

namespace TSE3
{
    class DisplayParams;
}

/**
 * This class provides a widget that alters a TSE3 @ref DisplayParams.
 *
 * @short   DisplayParams settings widget.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class DisplayParamsWidget : public SettingsWidget
{
    public:

        /**
         * @param useDefault Passed to the @ref DPColourWodget
         */
        DisplayParamsWidget(TSE3::DisplayParams *mp, bool useDefault,
                            QWidget *parent, const char *name = 0);
        virtual ~DisplayParamsWidget();
        virtual void setValues();
        virtual void updateWidgets();

        /**
         * Places the current values into the specified object.
         */
        void setValues(TSE3::DisplayParams &dp);

    private:

        TSE3::DisplayParams *dp;
        DPColourWidget      *colour;
};

#endif
