/*
 * @(#)Instrument.h 1.00 11 Oct 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_INSTRUMENT_H
#define ANTHEM_INSTRUMENT_H

#include "SettingsWidget.h"

#include "tse3/Notifier.h"
#include "tse3/listen/ins/Destination.h"

#include <kdialogbase.h>

class KListBox;
class QListView;

namespace TSE3
{
    namespace Ins
    {
        class CakewalkInstrumentFile;
    }
}

/**
 * This window allows the user to manipulate the TSE3 destination
 * table and currently loaded instrument definitions.
 *
 * @short   Destination/instrument setup window.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class InstrumentWidget : public SettingsWidget,
                         public TSE3::Listener<TSE3::Ins::DestinationListener>
{
        Q_OBJECT;

    public:

        InstrumentWidget(QWidget *parent = 0);
        virtual void setValues();
        virtual void updateWidgets();

        /**
         * @reimplemented
         */
        virtual void Destination_Altered(TSE3::Ins::Destination *,
                                         size_t /*channel*/,
                                         size_t /*port*/,
                                         TSE3::Ins::Instrument *);

        /**
         * @reimplemented
         */
        virtual void Destination_InstrumentAdded(TSE3::Ins::Destination*,
                                                 TSE3::Ins::Instrument *);

        /**
         * @reimplemented
         */
        virtual void Destination_InstrumentRemoved(TSE3::Ins::Destination *,
                                                   TSE3::Ins::Instrument *);

    private slots:

        /**
         * Called to add an instrument definition file.
         */
        void slotAddInstrument();

        /**
         * Automatically attached to delete an instrument definition.
         */
        void slotDeleteInstrument();

        /**
         * Attached to dest box selectionChanged signal.
         */
        void slotSelectionChanged();

        /**
         * Attached to combo activated signal.
         */
        void slotComboActivated(int item);

        /**
         * Connected to an InstrumentChoiceWindow
         */
        void slotInstrument(TSE3::Ins::Instrument *instrument);

    private:

        void updateComboEnabled();
        void updateComboItems();
        void updateDestinations();
        void updateInstruments();

        QListView *destBox;
        KListBox  *insBox;
        QComboBox *combo;
};

/**
 * Having chosen a Calkewalk instrument definition file, this dialogue
 * will prompt the user to select an instrument. It then passes this instrument
 * back to it's parent.
 *
 * @short   Destination/instrument setup window.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class InstrumentChoiceWindow : public KDialogBase
{
        Q_OBJECT;

    public:

        InstrumentChoiceWindow(QString file, QWidget *parent = 0);
        virtual ~InstrumentChoiceWindow();

    signals:

        /**
         * This signal is emitted when an instrument is chosen bu the
         * user. The InstrumentChoiceWindow creates the TSE3::Ins::Instrument
         * object and passes it through this signal. If nothing catches
         * this signal then there will be a memory leak.
         *
         * After emitting this signal, the InstrumentChoiceWindow will close
         * and delete itself.
         */
        void instrument(TSE3::Ins::Instrument *instrument);

    public slots:

        virtual void accept();

    protected slots:

        void slotClose();

    private slots:

        void slotExecuted(QListBoxItem *item);

    private:

        KListBox                          *listBox;
        TSE3::Ins::CakewalkInstrumentFile *cif;
};

#endif
