/*
 * @(#)Metronome.cpp 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "settings/Metronome.h"

#include "gadgets/KeyWidgets.h"
#include "tse3/kdeui/ClockWidget.h"
#include "Application.h"

#include <cmath>

#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qbuttongroup.h>

#include <kdialogbase.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <kcolorbtn.h>

#include "tse3/Song.h"
#include "tse3/Track.h"
#include "tse3/Part.h"
#include "tse3/MidiParams.h"
#include "tse3/DisplayParams.h"
#include "tse3/Metronome.h"
#include "tse3/MidiEcho.h"
#include "tse3/MidiScheduler.h"
#include "tse3/Transport.h"
#include "tse3/plt/OSS.h"
#include "tse3/cmd/Track.h"

namespace
{
    const int   LINEEDIT_WIDTH = 300;
    const char *SPIN_OFF      = "Off";
    const char *SPIN_NONE     = "None";
}

/******************************************************************************
 * MetronomeWidget class
 *****************************************************************************/

MetronomeWidget::MetronomeWidget(TSE3::Metronome *metro, QWidget *parent,
                                 const char *name)
: SettingsWidget
      (new SettingsImpl<TSE3::MetronomeListener>(metro), parent, name),
  m(metro)
{
    QVBoxLayout *layout = new QVBoxLayout(this, KDialogBase::spacingHint(), -1);

    QGridLayout *gl = new QGridLayout(layout, 5 /*?*/, 4);

    QLabel *label = new QLabel("Channel", this);
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 0, 0);
    channel = new QSpinBox(1, 16, 1, this);
    gl->addWidget(channel, 0, 1);

    const size_t noPorts = Application::application()->scheduler()->numPorts();
    label = new QLabel("Port", this);
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 0, 2);
    port = new QSpinBox(1, noPorts, 1, this);
    gl->addWidget(port, 0, 3);

    label = new QLabel("Duration", this);
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 1, 0);
    duration = new ClockWidget(this, false);
    gl->addWidget(duration, 1, 1);

    label = new QLabel("Bar note", this);
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 2, 0);
    barNote = new KeyWidget(0x40, this);
    gl->addWidget(barNote, 2, 1);

    label = new QLabel("Bar velocity", this);
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 2, 2);
    barVelocity = new QSpinBox(1, 128, 1, this);
    gl->addWidget(barVelocity, 2, 3);

    label = new QLabel("Beat note", this);
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 3, 0);
    beatNote = new KeyWidget(0x40, this);
    gl->addWidget(beatNote, 3, 1);

    label = new QLabel("Beat velocity", this);
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 3, 2);
    beatVelocity = new QSpinBox(1, 128, 1, this);
    gl->addWidget(beatVelocity, 3, 3);

    playing = new QCheckBox("Playing", this);
    gl->addWidget(playing, 4, 1);
    recording = new QCheckBox("Recording", this);
    gl->addWidget(recording, 4, 3);

    layout->addStretch();
    updateWidgets();
}


MetronomeWidget::~MetronomeWidget()
{
}


void MetronomeWidget::setValues()
{
    m->setChannel(channel->value()-1);
    m->setPort(port->value()-1);
    m->setDuration(duration->value());
    m->setBarNote(barNote->value()-1);
    m->setBarVelocity(barVelocity->value()-1);
    m->setBeatNote(beatNote->value()-1);
    m->setBeatVelocity(beatVelocity->value()-1);
    m->setStatus(TSE3::Transport::Playing, playing->isChecked());
    m->setStatus(TSE3::Transport::Recording, recording->isChecked());
}


void MetronomeWidget::updateWidgets()
{
    channel->setValue(m->channel()+1);
    port->setValue(m->port()+1);
    duration->setValue(m->duration());
    barNote->setValue(m->barNote()+1);
    barVelocity->setValue(m->barVelocity()+1);
    beatNote->setValue(m->beatNote()+1);
    beatVelocity->setValue(m->beatVelocity()+1);
    playing->setChecked(m->status(TSE3::Transport::Playing));
    recording->setChecked(m->status(TSE3::Transport::Recording));
}

