/*
 * @(#)MidiEcho.cpp 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "settings/MidiEcho.h"

#include "settings/MidiFilter.h"
#include "Application.h"

#include "tse3/MidiScheduler.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qspinbox.h>

#include <kdialogbase.h>

#include "tse3/MidiEcho.h"

/******************************************************************************
 * MidiEchoWidget class
 *****************************************************************************/

MidiEchoWidget::MidiEchoWidget(TSE3::MidiEcho *me, QWidget *parent,
                                 const char *name)
: SettingsWidget(new SettingsImpl<TSE3::MidiEchoListener>(me), parent, name),
  me(me)
{
    QVBoxLayout *layout = new QVBoxLayout(this, KDialogBase::spacingHint(), -1);

    QGridLayout *gl = new QGridLayout(layout, 1, 4);

    QLabel *label = new QLabel("Channel", this);
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 0, 0);
    channel = new QSpinBox(0, 16, 1, this);
    channel->setSpecialValueText("Any");
    gl->addWidget(channel, 0, 1);

    const size_t noPorts = Application::application()->scheduler()->numPorts();
    label = new QLabel("Port", this);
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 0, 2);
    port = new QSpinBox(0, noPorts, 1, this);
    port->setSpecialValueText("Any");
    gl->addWidget(port, 0, 3);

    QGroupBox *gb = new QGroupBox(1, Horizontal, "Midi echo filter", this);
    layout->addWidget(gb);
    mf = new MidiFilterWidget(me->filter(), gb);

    updateWidgets();
}


MidiEchoWidget::~MidiEchoWidget()
{
}


void MidiEchoWidget::setValues()
{
    me->setChannel(channel->value()-1);
    me->setPort(port->value()-1);
    mf->setValues();
}


void MidiEchoWidget::updateWidgets()
{
    channel->setValue(me->channel()+1);
    port->setValue(me->port()+1);
    mf->updateWidgets();
}

