/*
 * @(#)MidiFilter.h 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_SETTINGS_MIDIFILTER_H
#define ANTHEM_SETTINGS_MIDIFILTER_H

#include "settings/SettingsWidget.h"

/******************************************************************************
 * Qt/KDE forward declarations
 *****************************************************************************/
class QCheckBox;
class QRadioButton;
class QSpinBox;

/******************************************************************************
 * Anthem forward declarations
 *****************************************************************************/
class ClockWidget;
class ChannelWidget;
class PortWidget;

/******************************************************************************
 * TSE3 forward declarations
 *****************************************************************************/
namespace TSE3
{
    class MidiFilter;
}

/**
 * This class provides a widget that alters a TSE3 @ref MidiFilter.
 *
 * @short   MidiFilter settings widget.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class MidiFilterWidget : public SettingsWidget
{
        Q_OBJECT;

    public:
        MidiFilterWidget(TSE3::MidiFilter *mf,
                         QWidget *parent, const char *name = 0);
        virtual ~MidiFilterWidget();
        virtual void setValues();
        virtual void updateWidgets();
        /**
         * Places the current values into the specified object.
         */
        void setValues(TSE3::MidiFilter &mf);
    private slots:
        /**
         * The offset widget has changed, handle enabling/disabling the
         * forwards/backwards radio buttons
         */
        void handleOffsetChanged();
    private:
        size_t              noPorts;
        TSE3::MidiFilter   *mf;
        QCheckBox          *status;
        QCheckBox          *channelFilter[16];
        ChannelWidget      *channel;
        PortWidget         *port;
        ClockWidget        *offset;
        QRadioButton       *backwards;
        QRadioButton       *forwards;
        QSpinBox           *timeScale;
        ClockWidget        *quantise;
        QSpinBox           *transpose;
        QSpinBox           *velScale;
        QSpinBox           *minVel;
        QSpinBox           *maxVel;
};

#endif
