/*
 * @(#)MidiParams.cpp 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "settings/MidiParams.h"

#include "Application.h"
#include "gadgets/VoiceWidget.h"
#include "gadgets/MidiParamsSpinBox.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qspinbox.h>

#include <kdialogbase.h>

#include "tse3/MidiParams.h"

/******************************************************************************
 * MidiParamsWidget class
 *****************************************************************************/

MidiParamsWidget::MidiParamsWidget(TSE3::MidiParams *mp,
                                   QWidget *parent, const char *name)
: SettingsWidget(new SettingsImpl<TSE3::MidiParamsListener>(mp), parent, name),
  mp(mp)
{
    QVBoxLayout *layout = new QVBoxLayout(this, KDialogBase::spacingHint());

    // Patch
    QGroupBox *groupBox = new QGroupBox(1, Horizontal, "Patch", this);
    layout->addWidget(groupBox);

    voice = new VoiceWidget(true, 0, 0, 0, 0, 0, groupBox);

    // Effects
    groupBox = new QGroupBox(4, Horizontal, "Effects", this);
    layout->addWidget(groupBox);

    // Volume/pan
    QLabel *label = new QLabel("Volume", groupBox);
    label->setAlignment(AlignRight|AlignVCenter);
    volume = new MidiParamsSpinBox(groupBox);
    label = new QLabel("Pan", groupBox);
    label->setAlignment(AlignRight|AlignVCenter);
    pan = new MidiParamsSpinBox(groupBox);

    // Chorus/reverb
    label = new QLabel("Chorus", groupBox);
    label->setAlignment(AlignRight|AlignVCenter);
    chorus = new MidiParamsSpinBox(groupBox);
    label = new QLabel("Reverb", groupBox);
    label->setAlignment(AlignRight|AlignVCenter);
    reverb = new MidiParamsSpinBox(groupBox);

    layout->addStretch(1);

    updateWidgets();
}


MidiParamsWidget::~MidiParamsWidget()
{
}


void MidiParamsWidget::setValues()
{
    setValues(*mp);
}


void MidiParamsWidget::setValues(TSE3::MidiParams &mp)
{
    mp.setProgram(voice->program());
    mp.setBankLSB(voice->bankLSB());
    mp.setBankMSB(voice->bankMSB());
    mp.setVolume(volume->value());
    mp.setPan(pan->value());
    mp.setReverb(reverb->value());
    mp.setChorus(chorus->value());
}


void MidiParamsWidget::updateWidgets()
{
    voice->setValues(mp->program(), mp->bankLSB(), mp->bankMSB());
    volume->setValue(mp->volume());
    pan->setValue(mp->pan());
    reverb->setValue(mp->reverb());
    chorus->setValue(mp->chorus());
}

