/*
 * @(#)MidiParams.h 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_SETTINGS_MIDIPARAMS_H
#define ANTHEM_SETTINGS_MIDIPARAMS_H

#include "settings/SettingsWidget.h"

/******************************************************************************
 * Anthem forward declarations
 *****************************************************************************/
class MidiParamsSpinBox;
class VoiceWidget;

/******************************************************************************
 * TSE3 forward declarations
 *****************************************************************************/
namespace TSE3
{
    class MidiParams;
}

/**
 * This class provides a widget that alters a TSE3 @ref MidiParams.
 *
 * @short   MidiParams settings widget.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class MidiParamsWidget : public SettingsWidget
{
    public:
        MidiParamsWidget(TSE3::MidiParams *mp,
                         QWidget *parent, const char *name = 0);
        virtual ~MidiParamsWidget();
        virtual void setValues();
        virtual void updateWidgets();
        /**
         * Places the current values into the specified object.
         */
        void setValues(TSE3::MidiParams &mp);
    private:
        TSE3::MidiParams  *mp;
        VoiceWidget       *voice;
        MidiParamsSpinBox *volume;
        MidiParamsSpinBox *pan;
        MidiParamsSpinBox *chorus;
        MidiParamsSpinBox *reverb;
};

#endif
