/*
 * @(#)OSSMidiScheduler.cpp 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "settings/OSSMidiScheduler.h"
#include "gadgets/MidiSchedulerWidgets.h"
#include "Application.h"

#include <cmath>

#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qscrollview.h>

#include <kdialogbase.h>
#include <kfiledialog.h>
#include <kmessagebox.h>

#include "tse3/plt/OSS.h"

namespace
{
    const int LINEEDIT_WIDTH = 300;
}

/******************************************************************************
 * OSSMidiSchedulerWidget class
 *****************************************************************************/

OSSMidiSchedulerWidget::OSSMidiSchedulerWidget(QWidget *parent,
                                               const char *name)
: SettingsWidget(new SettingsImpl<TSE3::MidiSchedulerListener>(0), parent, name)
{
    QVBoxLayout *layout = new QVBoxLayout(this, KDialogBase::spacingHint(), -1);

    QGroupBox *gb = new QGroupBox(1, Horizontal, "Information", this);
    layout->addWidget(gb);

    QScrollView *sv = new QScrollView(gb);
    //layout->addWidget(sv);
    QWidget *widget = new QWidget(sv->viewport());
    sv->addChild(widget);
    sv->setResizePolicy(QScrollView::AutoOneFit);
    QVBoxLayout *layout2 = new QVBoxLayout(widget, KDialogBase::spacingHint());
    MidiSchedulerInfoWidget *msiw = new MidiSchedulerInfoWidget
        (widget, Application::application()->scheduler());
    layout2->addWidget(msiw);

    QGridLayout *layout1 =
        new QGridLayout(layout, 2, 3, KDialogBase::spacingHint());

    QLabel *label = new QLabel("FM patches direcory:", this);
    label->setAlignment(AlignRight|AlignVCenter);
    layout1->addWidget(label, 0, 0);
    fmdir = new QLineEdit("XXX", this);
    fmdir->setMinimumWidth(LINEEDIT_WIDTH);
    layout1->addWidget(fmdir, 0, 1);
    QPushButton *pb = new QPushButton("Browse", this);
    pb->adjustSize();
    pb->setMaximumWidth(pb->width());
    layout1->addWidget(pb, 0, 2);
    connect(pb, SIGNAL(clicked()), SLOT(slotFmClicked()));

    label = new QLabel("GUS patches direcory:", this);
    label->setAlignment(AlignRight|AlignVCenter);
    layout1->addWidget(label, 1, 0);
    gusdir = new QLineEdit("XXX", this);
    gusdir->setMinimumWidth(LINEEDIT_WIDTH);
    layout1->addWidget(gusdir, 1, 1);
    pb = new QPushButton("Browse", this);
    pb->adjustSize();
    pb->setMaximumWidth(pb->width());
    layout1->addWidget(pb, 1, 2);
    connect(pb, SIGNAL(clicked()), SLOT(slotGusClicked()));

    layout->addStretch(1);

    updateWidgets();
}


OSSMidiSchedulerWidget::~OSSMidiSchedulerWidget()
{
}


void OSSMidiSchedulerWidget::setValues()
{
    if (fmdir->text()
        != QString(TSE3::Plt::OSSMidiScheduler::fmPatchesDirectory().c_str()))
    {
        TSE3::Plt::OSSMidiScheduler::setFmPatchesDirectory
            (fmdir->text().latin1());
        KMessageBox::information(this, "For the change in FM directory to "
                                 "take effect you must restart the program.");
    }
    if (gusdir->text()
        != QString(TSE3::Plt::OSSMidiScheduler::gusPatchesDirectory().c_str()))
    {
        TSE3::Plt::OSSMidiScheduler::setGusPatchesDirectory
            (fmdir->text().latin1());
        KMessageBox::information(this, "For the change in GUS directory to "
                                 "take effect you must restart the program.");
    }
}


void OSSMidiSchedulerWidget::updateWidgets()
{
    fmdir->setText(TSE3::Plt::OSSMidiScheduler::fmPatchesDirectory()
                       .c_str());
    gusdir->setText(TSE3::Plt::OSSMidiScheduler::gusPatchesDirectory()
                        .c_str());
}


void OSSMidiSchedulerWidget::slotFmClicked()
{
    QString s = KFileDialog::getExistingDirectory(fmdir->text(), this,
                                                  "FM patches directory");
    if (!s.isEmpty())
    {
        fmdir->setText(s);
    }
}


void OSSMidiSchedulerWidget::slotGusClicked()
{
    QString s = KFileDialog::getExistingDirectory(gusdir->text(), this,
                                                  "GUS patches directory");
    if (!s.isEmpty())
    {
        gusdir->setText(s);
    }
}

