/*
 * @(#)Part.h 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_SETTINGS_PART_H
#define ANTHEM_SETTINGS_PART_H

#include "settings/SettingsWidget.h"

#include "tse3/Midi.h"

/******************************************************************************
 * Anthem forward declarations
 *****************************************************************************/
class ClockWidget;
class PhraseSelectEditWidget;

/******************************************************************************
 * TSE3 forward declarations
 *****************************************************************************/
namespace TSE3
{
    class Song;
    class Part;
    class Phrase;
}

/**
 * This class provides a widget that alters a TSE3 @ref Part.
 *
 * @short   Part settings widget
 * @author  Pete Goodliffe
 * @version 1.0
 */
class PartWidget : public SettingsWidget
{
    public:
        /**
         * Specify the @ref TSE3::Part to be altered, and also the
         * @ref TSE3::Song it is in (needed to create the
         * @ref PhraseSelectWidget).
         */
        PartWidget(TSE3::Part *p, TSE3::Song *s,
                   QWidget *parent, const char *name = 0);
        virtual ~PartWidget();
        virtual void setValues();
        virtual void updateWidgets();
        /**
         * Returns the currently selected @ref TSE3::Phrase.
         */
        TSE3::Phrase *phrase();
        /**
         * Returns the currently selected repeat setting.
         */
        TSE3::Clock repeat();
    private:
        TSE3::Part             *p;
        PhraseSelectEditWidget *phraseSelect;
        ClockWidget            *_repeat;
};

#endif
