/*
 * @(#)Settings.h 1.00 14 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_SETTINGS_H
#define ANTHEM_SETTINGS_H

#include <kdialogbase.h>

class MetronomeWidget;
class MidiEchoWidget;
class PanicWidget;
class MidiFilterWidget;
class MidiMapperWidget;
class TransportWidget;
class OSSMidiSchedulerWidget;
class InstrumentWidget;
class PartViewWidget;
class PresetColoursWidget;
class VuWindowWidget;
class ApplicationWidget;
class PluginsWidget;

/**
 * The SettingsWindow alows the user to alter a @ref Track's settings.
 *
 * @short   Track settings window.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class SettingsWindow : public KDialogBase
{
        Q_OBJECT

    public:

        /**
         * Creates a Settings settings window.
         */
        SettingsWindow(QWidget *parent = 0);

        /**
         * Dtor - the @Ref Track is not deleted.
         */
        virtual ~SettingsWindow();

        /**
         * Updates the values before showing the window.
         */
        virtual void show();

    public slots:

        /**
         * @reimplemented
         */
        void accept();

        /**
         * @reimplemented
         */
        void done(int reason);

        /**
         * @reimplemented
         */
        void slotApply();

        /**
         * @reimplemented - Reset
         */
        void slotUser1();

        /**
         * @reimplemented - Save
         */
        void slotUser2();

    signals:

        void closed();

    private:

        /**
         * Sets the values for every child widget.
         */
        void setValues();

        /**
         * Updates all the widgets in the window to reflect the current
         * state of the @ref Part.
         */
        void updateWidgets();

        // UI objects

        MetronomeWidget        *mwidget;
        MidiEchoWidget         *ewidget;
        PanicWidget            *spwidget;
        PanicWidget            *epwidget;
        MidiFilterWidget       *fwidget;
        TransportWidget        *twidget;
        OSSMidiSchedulerWidget *mswidget;
        InstrumentWidget       *inswidget;
        PartViewWidget         *pvwidget;
        PresetColoursWidget    *pcwidget;
        VuWindowWidget         *vuwidget;
        ApplicationWidget      *awidget;
        PluginsWidget          *plugwidget;
};

#endif
