/*
 * @(#)Track.cpp 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "settings/Track.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qgroupbox.h>

#include <kdialogbase.h>

#include "tse3/Track.h"

namespace
{
    const int LINEEDIT_WIDTH = 300;
}

/******************************************************************************
 * TrackWidget class
 *****************************************************************************/

TrackWidget::TrackWidget(TSE3::Track *t, QWidget *parent, const char *name)
: SettingsWidget(new SettingsImpl<TSE3::TrackListener>(t), parent, name), t(t)
{
    QVBoxLayout *layout = new QVBoxLayout(this, KDialogBase::spacingHint(), -1);
    QGridLayout *gl = new QGridLayout(layout, 1, 2);

    // Title
    QLabel *label = new QLabel("Title", this);
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 0, 0);
    titleEdit = new QLineEdit("XXX", this);
    titleEdit->setMinimumWidth(LINEEDIT_WIDTH);
    gl->addWidget(titleEdit, 0, 1);
    titleEdit->setFocus();

    // Information
    layout->addStretch(1);
    QGroupBox *groupBox = new QGroupBox(2, Horizontal, "Information", this);
    layout->addWidget(groupBox);
    label = new QLabel("Track type:", groupBox);
    label->setAlignment(AlignRight|AlignVCenter);
    label = new QLabel("MIDI Track", groupBox);
    label->setAlignment(AlignLeft|AlignVCenter);
    label = new QLabel("Number of parts:", groupBox);
    label->setAlignment(AlignRight|AlignVCenter);
    noParts = new QLabel("XXX", groupBox);
    noParts->setAlignment(AlignLeft|AlignVCenter);

    layout->addStretch(10);

    updateWidgets();
}


TrackWidget::~TrackWidget()
{
}


void TrackWidget::setValues()
{
    t->setTitle(titleEdit->text().latin1());
}


const QString TrackWidget::title()
{
    return titleEdit->text();
}


void TrackWidget::updateWidgets()
{
    titleEdit->setText(t->title().c_str());
    QString s;
    s.sprintf("%i", t->size());
    noParts->setText(s);
}
