/*
 * @(#)Transport.h 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_SETTINGS_TRANSPORT_H
#define ANTHEM_SETTINGS_TRANSPORT_H

#include "settings/SettingsWidget.h"

class QLabel;
class QCheckBox;

class ClockWidget;

/**
 * This class provides a widget that alters a TSE3 @ref Transport.
 *
 * @short   Transport settings widget.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class TransportWidget : public SettingsWidget
{
        Q_OBJECT;
    public:
        TransportWidget(QWidget *parent, const char *name = 0);
        virtual ~TransportWidget();
        virtual void setValues();
        virtual void updateWidgets();
    private slots:
        void updateDisable();
    private:
        QCheckBox   *autoStop;
        ClockWidget *playLeadIn;
        ClockWidget *recordLeadIn;
        QCheckBox   *adaptiveLookAhead;
        QLabel      *lookAheadLabel;
        ClockWidget *lookAhead;
        QLabel      *breakUps;
};

#endif
