/*
 * @(#)VuWindow.cpp 1.00 9 May 2002
 *
 * Copyright (c) Pete Goodliffe 2002 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "settings/VuWindow.h"

#include "gadgets/Gadgets.h"

#include <qlayout.h>
#include <qlabel.h>

#include <kdialogbase.h>
#include <kcombobox.h>


/******************************************************************************
 * VuWindow class
 *****************************************************************************/

VuWindowWidget::VuWindowWidget(QWidget *parent, const char *name)
: SettingsWidget(0, parent, name)
{
    QVBoxLayout *layout = new QVBoxLayout(this, KDialogBase::spacingHint());
    QGridLayout *gl = new QGridLayout(layout, 1, 2);

    QLabel *label = new QLabel("Update for events", this);
    gl->addWidget(label, 1, 0);
    combo = new KComboBox(this);
    combo->setInsertionPolicy(QComboBox::NoInsertion);
    combo->insertItem("coming in");
    combo->insertItem("going out");
    combo->insertItem("in both directions");
    gl->addWidget(combo, 1, 1);

    layout->addStretch(1);

    updateWidgets();
}


VuWindowWidget::~VuWindowWidget()
{
}


void VuWindowWidget::setValues()
{
    VuWindow::setStatus(combo->currentItem());
}


void VuWindowWidget::updateWidgets()
{
    combo->setCurrentItem(VuWindow::status());
}

