/*
 * @(#)VuWindow.h 1.00 9 May 2002
 *
 * Copyright (c) Pete Goodliffe 2002 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_SETTINGS_VUWINDOW_H
#define ANTHEM_SETTINGS_VUWINDOW_H

#include "settings/SettingsWidget.h"

#include "gadgets/Gadgets.h"

class KComboBox;

/**
 * This class provides a widget that alters a @ref PartView.
 *
 * @short   PartView settings widget.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class VuWindowWidget : public SettingsWidget
{
    public:
        VuWindowWidget(QWidget *parent, const char *name = 0);
        virtual ~VuWindowWidget();
        virtual void setValues();
        virtual void updateWidgets();

    private:

        KComboBox *combo;
};

#endif
