/*
 * @(#)Actions.h 1.00 2 may 2002
 *
 * Copyright (c) Pete Goodliffe 2002 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_SONGWINDOW_ACTIONS_H
#define ANTHEM_SONGWINDOW_ACTIONS_H

#include <kaction.h>

/**
 * This is a class of KAction that will insert a generic QWidget into
 * a toolbar, and do nothing else special otherwise.
 *
 * Plugging the action reparents the QWidget. If you want to use the
 * widget later on, you will have to store your own pointer to it.
 *
 * The action can only be plugged the one time.
 *
 * @short   Generic toolbar @ref QWidget @ref KAction
 * @author  Pete Goodliffe
 * @version 1.0
 */
class QWidgetAction : public KAction
{
    public:

        QWidgetAction(const QString &text, QWidget *widget,
                      QObject *parent, const char* name);
        virtual ~QWidgetAction();

        virtual int plug(QWidget *widget, int index = -1);
        virtual void unplug(QWidget *w);

        QWidget *widget() { return _widget; }

    private:

        QWidget *_widget;
        bool     plugged;
};


/**
 * A KAction class that plugs normal @ref KAction type objects, but makes a
 * toolbar button autorepeat.
 *
 * @short   Toolbar auto repeat @ref KAction
 * @author  Pete Goodliffe
 * @version 1.0
 */
class AutoRepeatAction : public KAction
{
    public:

        /**
         * I only provide the one ctor type, since it's the only one I use.
         */
        AutoRepeatAction(const QString& text, const QString& pix, int accel,
                         const QObject* receiver, const char* slot,
                         QObject* parent, const char* name = 0);
        virtual ~AutoRepeatAction();

        virtual int plug(QWidget *widget, int index = -1);
};


/**
 * A KAction class like KToggleAction, but whose toolbar button will
 * accept second clicks, but won't detoggle, it will just emit another
 * toggled(true).
 *
 * You probably want to ignore toggled and use.
 *
 * @short   Toolbar auto repeat @ref KAction
 * @author  Pete Goodliffe
 * @version 1.0
 */
class RepeatToggleAction : public KToggleAction
{
    public:

        /**
         * I only provide the one ctor type, since it's the only one I use.
         */
        RepeatToggleAction(const QString& text, const QString& pix, int accel,
                         const QObject* receiver, const char* slot,
                         QObject* parent, const char* name = 0);
        virtual ~RepeatToggleAction();
    protected slots:
        virtual void slotActivated();
};

#endif
