/*
 * @(#)PhraseList.h 1.00 29 May 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_PHRASELIST_H
#define ANTHEM_PHRASELIST_H

#include <kdialogbase.h>

#include "tse3/Notifier.h"
#include "tse3/listen/PhraseList.h"
#include "tse3/listen/Phrase.h"

namespace TSE3
{
    class Song;
    class Part;
}

class KListBox;
class QPopupMenu;

/**
 * The PhraseListWindow privdes the list of @ref Phrases in a @ref Song.
 * such as the title, author etc.
 *
 * @short   Phrase list window.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class PhraseListWindow : public KDialogBase,
                         public TSE3::Listener<TSE3::PhraseListListener>,
                         public TSE3::Listener<TSE3::PhraseListener>
{
        Q_OBJECT

    public:

        /**
         * Creates a Phrase list window containing an entry for each
         * @ref TSE3::Phrase in the given @ref TSE3::Song. It will update with
         * the @ref TSE3::Song.
         *
         * The PhraseListWindow does not automatically open, you must show()
         * it yourself.
         */
        PhraseListWindow(QWidget *parent, TSE3::Song *song);

        virtual ~PhraseListWindow() {};

        /**
         * Changes which @ref TSE3::Song this window views.
         *
         * This can only be called safely by the @ref SongWindow.
         */
        void changeSong(TSE3::Song *song);

        /**
         * Returns a pointer to the currently selected @ref TSE3::Phrase, or
         * zero if there is none.
         */
        TSE3::Phrase *phrase();

        /**
         * @reimplemented
         */
        virtual void PhraseList_Inserted(TSE3::PhraseList *, TSE3::Phrase *phr);

        /**
         * @reimplemented
         */
        virtual void PhraseList_Removed(TSE3::PhraseList *, TSE3::Phrase *phr);

        /**
         * @reimplemented
         */
        virtual void Phrase_DisplayParamsAltered(TSE3::Phrase *);

    public slots:

        void accept();
        void done(int reason);

        /**
         * This is called when a @ref TSE3::Part is selected in the
         * @ref PartView, and causes any @ref TSE3::Phrase used by that
         * @ref TSE3::Part to be highlighted.
         */
        void slotPartSelected(TSE3::Part *part);

        /**
         * Perform a cut operation
         */
        void slotCut();

        /**
         * Perform a copy operation
         */
        void slotCopy();

        /**
         * Perform a paste operation
         */
        void slotPaste();

    signals:

        void opened();
        void closed();

        void phraseSelected(TSE3::Phrase *phrase);

    private slots:

        /**
         * When an item is executed, this will send a phraseSelected
         */
        void slotKListBoxItemExecuted(QListBoxItem *item);

        /**
         * Automatically attached to User1 button
         */
        virtual void slotUser1();

        /**
         * Automatically attached to User2 button
         */
        virtual void slotUser2();

        /*
         * Menu slots
         */
        void slotProperties();
        void slotNew();

    private:

        /**
         * Sets up the QListBox.
         */
        void setUpListBox();

        // TSE3 objects
        TSE3::Song       *song;
        TSE3::PhraseList *phraseList;

        // UI objects
        QWidget    *parent;
        QPopupMenu *menu;
        KListBox   *listBox;
};

#endif
