/*
 * @(#)SnapWidget.h 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef TSE3_KDEUI_SNAPWIDGET_H
#define TSE3_KDEUI_SNAPWIDGET_H

#include <qcombobox.h>

#include "tse3/Midi.h"

/**
 * This widget provides a combo box that can be used to choose a
 * @ref TSE3::Util::Snap value in pulses.
 *
 * @short   'Snap' value selection widget
 * @author  Pete Goodliffe
 * @version 1.0
 */
class SnapWidget : public QComboBox
{
        Q_OBJECT;

    public:

        SnapWidget(QWidget *parent, const char *name = 0);

        /**
         * Enum type of snap values.
         */
        enum
        {
            OffPos,
            BarPos,
            WholePos,
            HalfPos,
            Note4Pos,
            Note8Pos,
            Note16Pos,
            Note32Pos
        };

        enum
        {
            Off = -2,
            Bar = -1
        };

        /**
         * Returns the @ref TSE3::MidiClock value of the current selection
         * or the Off/Bar value.
         */
        TSE3::Clock snapValue()
        {
            return values[currentItem()];
        }

        /**
         * Sets the current snap value.
         */
        void setSnapValue(TSE3::Clock mc);

    signals:

        /**
         * Emitted when the snap value changes. The parameter is the
         * new snap value (a @ref TSE3::Clock value).
         */
        void valueChanged(int snapValue);

    private slots:

        /**
         * Attached to activated signal - emits a valueChanged.
         */
        void slotActivated(int index);

    private:

        /**
         * Lookup table
         */
        static const int values[];
};

#endif
