/*
 * @(#)About.cpp 1.00 22 May 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "dialogues/About.h"

#include "tse3/TSE3.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <kiconloader.h>
#include <kurllabel.h>

#if HAVE_CONFIG_H
#include "config.h"
#else
#define VERSION "[Not available]"
#endif

/*
 * It's not so much fun putting easter eggs in open source programs ;-)
 */

AboutWindow::AboutWindow(QWidget *parent)
: KAboutApplication(parent)
{
    QFrame *tsePage = addPage("About TSE3");
    QVBoxLayout *layout = new QVBoxLayout(tsePage, spacingHint());

    QLabel *label
        = new QLabel("Anthem uses TSE3 sequencer technology.", tsePage);
    layout->add(label);
    layout->addStretch(1);

    QGroupBox *gb = new QGroupBox(2, Horizontal, "TSE3 information", tsePage);
    label = new QLabel("Version:", gb);
    label->setAlignment(AlignRight|AlignVCenter);
    label = new QLabel(TSE3::TSE3_Version(), gb);
    label->setAlignment(AlignLeft|AlignVCenter);
    label = new QLabel("Copyright:", gb);
    label->setAlignment(AlignRight|AlignVCenter);
    label = new QLabel(TSE3::TSE3_Copyright(), gb);
    label->setAlignment(AlignLeft|AlignVCenter);
    label = new QLabel("Homepage:", gb);
    label->setAlignment(AlignRight|AlignVCenter);
    KURLLabel *url = new KURLLabel(gb);
    url->setText("http://TSE3.sourceforge.net");
    url->setURL("http://TSE3.sourceforge.net");
    url->setAlignment(AlignLeft|AlignVCenter);
    connect(url, SIGNAL(leftClickedURL(const QString &)),
            SLOT(openURL(const QString &)));

    layout->add(gb);
    layout->addStretch(2);

    setLogo(UserIcon("anthemlogo"));

/*    QWidget *widget = new QWidget(this);
    setMainWidget(widget);
    QHBoxLayout *layout1 = new QHBoxLayout(widget, 0, spacingHint());

    QLabel *sideImage = new QLabel(widget);
    sideImage->setPixmap(UserIcon("sideimage"));
    sideImage->setFrameShape(QFrame::Panel);
    sideImage->setFrameShadow(QFrame::Sunken);
    sideImage->setMargin(0);
    layout1->addWidget(sideImage);

    QVBoxLayout *layout = new QVBoxLayout(layout1);

    QLabel *label = new QLabel(widget);
    label->setPixmap(UserIcon("anthemlogo"));
    layout->addWidget(label);
*/
}


/*
 * moc can't see directly into the KAboutDialog::openURLSlot :-(
 */
void AboutWindow::openURL(const QString &url)
{
    openURLSlot(url);
}
