/*
 * @(#)Demidify.cpp 1.00 30 Mar 2002
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "dialogues/Demidify.h"

#include "tse3/util/Demidify.h"


DemidifyWindow::DemidifyWindow(TSE3::App::TrackSelection *ts, TSE3::Song *song,
                                QWidget *parent)
: KDialogBase(Plain, "Insert tracks", Cancel|Ok, Ok, parent,
              "DemidifyWindow", false, true),
  song(song), trackSelection(ts)
{
    QGridLayout *gl = new QGridLayout(plainPage(), 2, 3, spacingHint());

    QLabel *label = new QLabel("Insert", plainPage());
    label->setMinimumSize(label->sizeHint());
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 0, 0);


    show();
}


void DemidifyWindow::accept()
{
}


void DemidifyWindow::done(int reason)
{
    delayedDestruct();
}

