/*
 * @(#)NewFlag.cpp 1.00 27 April 2002
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "dialogues/NewFlag.h"

#include <qlabel.h>
#include <qlineedit.h>
#include <qlayout.h>

#include "tse3/Song.h"
#include "tse3/FlagTrack.h"
#include "tse3/cmd/FlagTrack.h"
#include "tse3/cmd/CommandHistory.h"

#include "tse3/kdeui/ClockWidget.h"
#include "Application.h"

namespace
{
    const int LINEEDIT_WIDTH = 200;
}

NewFlagWindow::NewFlagWindow(QWidget     *parent,
                             TSE3::Song  *song,
                             TSE3::Clock  time)
: KDialogBase(Plain, "New flag", Cancel|Ok, Ok, parent,
              "NewFlagWindow", true, true), song(song)
{
    QGridLayout *gl = new QGridLayout(plainPage(), 2, 2, spacingHint());

    // Title
    QLabel *label = new QLabel("Name", plainPage());
    label->setMinimumSize(label->sizeHint());
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 0, 0);
    name = new QLineEdit("New flag", plainPage());
    name->setMinimumWidth(LINEEDIT_WIDTH);
    gl->addWidget(name, 0, 1);
    name->setFocus();

    // Time
    label = new QLabel("Time", plainPage());
    label->setMinimumSize(label->sizeHint());
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 1, 0);
    clock = new ClockWidget(plainPage(), false, time);
    gl->addWidget(clock, 1, 1);

    attachTo(song->flagTrack());
}


void NewFlagWindow::accept()
{
    TSE3::Cmd::Command *command
        = new TSE3::Cmd::FlagTrack_Add(song->flagTrack(),
            TSE3::Event<TSE3::Flag>(TSE3::Flag(name->text().latin1()),
                                    clock->value()));
    command->execute();
    Application::application()->history(song)->add(command);
    done(Accepted);
}


void NewFlagWindow::Notifier_Deleted(TSE3::FlagTrack *)
{
    delete this;
}
