/*
 * @(#)NewPhrase.cpp 1.00 19 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "dialogues/NewPhrase.h"

#include "gadgets/PhraseSelectWidget.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <kmessagebox.h>

#include "tse3/PhraseList.h"

namespace
{
    const int LINEEDIT_WIDTH = 300;
}

NewPhraseWindow::NewPhraseWindow(QWidget *parent, TSE3::PhraseList *pl,
                                 QString title,
                                 bool replacePhrase, bool haveInsertPart,
                                 bool haveKeepOpen)
: KDialogBase(Plain, "New phrase", Cancel|Ok, Ok, parent,
              "NewPhraseWindow", true, true), phraseList(pl)
{
    QGridLayout *gl = new QGridLayout(plainPage(), 3, 2, spacingHint());

    // Title
    QLabel *label = new QLabel("Title", plainPage());
    label->setMinimumSize(label->sizeHint());
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 0, 0);
    titleEdit = new PhraseSelectWidget(pl, true, 0, plainPage());
    titleEdit->setMinimumWidth(LINEEDIT_WIDTH);
    titleEdit->setEditable(true);
    gl->addWidget(titleEdit, 0, 1);
    titleEdit->lineEdit()->setFocus();
    titleEdit->setEditText(title);

    // Checkbuttons
    replace = new QCheckBox("Replace phrase", plainPage());
    replace->setChecked(false);
    gl->addWidget(replace, 1, 1);

    if (haveInsertPart)
    {
        insert = new QCheckBox("Insert part", plainPage());
        insert->setChecked(true);
        gl->addWidget(insert, 2, 1);
    }
    else
    {
        insert = 0;
    }

    if (haveKeepOpen)
    {
        keepOpen = new QCheckBox("Keep editor open", plainPage());
        keepOpen->setChecked(false);
        gl->addWidget(keepOpen, 3, 1);
    }
    else
    {
        keepOpen = 0;
    }
}


void NewPhraseWindow::accept()
{
    if (!titleEdit->lineEdit()->text().isEmpty())
    {
        if (!replace->isChecked()
            && phraseList->phrase(titleEdit->lineEdit()->text().latin1()))
        {
            KMessageBox::sorry(this,
                "A phrase with that name already exists in the phrase list.");
            return;
        }

        done(Accepted);
    }
    else
    {
        std::string str = phraseList->newPhraseTitle();
        titleEdit->lineEdit()->setText(str.c_str());
        KMessageBox::sorry(this,
            "You must specify a new phrase name.\n"
            "An example name has been created for you.");
    }
}


void NewPhraseWindow::done(int reason)
{
    emit newPhraseDone(reason == Accepted,
                       titleEdit->lineEdit()->text().latin1(),
                       replace  ? replace->isChecked()  : false,
                       insert   ? insert->isChecked()   : false,
                       keepOpen ? keepOpen->isChecked() : false);
    KDialogBase::done(reason);
}
