/*
 * @(#)NewTrack.h 1.00 2 Jan 2001
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_NEWTRACK_H
#define ANTHEM_NEWTRACK_H

#include <kdialogbase.h>

#include "tse3/Notifier.h"
#include "tse3/listen/app/TrackSelection.h"

class QComboBox;
class QSpinBox;

namespace TSE3
{
    class Song;
    class Track;
}

/**
 * The NewTrackWindow alows the user to insert more @ref TSE3::Track objects
 * into a @ref TSE3::Song.
 *
 * @short   New track insertion window.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class NewTrackWindow : public KDialogBase,
                       public TSE3::Listener<TSE3::App::TrackSelectionListener>
{
        Q_OBJECT

    public:

        /**
         * Creates a NewTrackWindow for the given Song.
         *
         */
        NewTrackWindow(TSE3::App::TrackSelection *ts, TSE3::Song *song,
                       QWidget *parent);
        virtual ~NewTrackWindow() {};

        /**
         * @reimplemented
         */
        virtual void TrackSelection_Selected
            (TSE3::App::TrackSelection *, TSE3::Track *, bool selected);

    public slots:

        void accept();
        void done(int reason);

    private:

        /**
         * Sets for before/after *selection* or *current tracks*.
         */
        void updateWidgets();

        TSE3::Song                *song;
        TSE3::App::TrackSelection *trackSelection;
        QSpinBox                  *number;
        QComboBox                 *where;
        QLabel                    *wherelabel;
};

#endif
