/*
 * @(#)Part.h 1.00 30 May 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_PANIC_H
#define ANTHEM_PANIC_H

#include <kdialogbase.h>

class PanicWidget;

namespace TSE3
{
    class Panic;
    class Transport;
}

/**
 * The PanicWindow provides a @ref TSE3:Panic which can be set up and sent
 * at any point in time. You can send the panic when OK is pressed, or
 * at any other time when the window may not be open.
 *
 * @short   Panic utility window.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class PanicWindow : public KDialogBase
{
        Q_OBJECT

    public:

        /**
         * Creates a Panic window.
         */
        PanicWindow(QWidget *parent = 0);

        /**
         * Dtor - the @ref Part is not deleted.
         */
        virtual ~PanicWindow();

    public slots:

        void send();

    private:

        // TSE3 objects
        TSE3::Panic     *panic;
        TSE3::Transport *transport;

        // UI objects

        PanicWidget *pwidget;
};

#endif
