/*
 * @(#)Phrase.h 1.00 30 May 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_DIALOGUES_PHRASE_H
#define ANTHEM_DIALOGUES_PHRASE_H

#include <kdialogbase.h>

#include "tse3/Notifier.h"
#include "tse3/listen/Phrase.h"

class PhraseWidget;
class DisplayParamsWidget;

namespace TSE3
{
    namespace Cmd
    {
        class CommandHistory;
    }
}

/**
 * The PhraseWindow alows the user to alter a @ref Phrase's settings.
 *
 * @short   Phrase settings window
 * @author  Pete Goodliffe
 * @version 1.0
 */
class PhraseWindow : public KDialogBase,
                     public TSE3::Listener<TSE3::PhraseListener>
{
        Q_OBJECT

    public:

        /**
         * Creates a Phrase settings window for the given @ref TSE3::Phrase.
         * You specify the @ref TSE3::Cmd::CommandHistory that will
         * be used to store the phrase info set command.
         */
        PhraseWindow(QWidget *parent, TSE3::Phrase *phrase,
                     TSE3::Cmd::CommandHistory *history);

        /**
         * Dtor - the @ref Track is not deleted.
         */
        virtual ~PhraseWindow();

        /**
         * Updates the values before showing the window.
         */
        virtual void show();

        /**
         * @reimplemented
         */
        virtual void Notifier_Deleted(TSE3::Phrase *phrase);

    public slots:

        /**
         * @reimplemented
         */
        void accept();

        /**
         * @reimplemented
         */
        void done(int reason);

        /**
         * @reimplemented
         */
        void slotApply();

    signals:

        void closed();

    private:

        /**
         * Updates all the widgets in the window to reflect the current
         * state of the @ref Track.
         */
        void updateWidgets();

        /**
         * Sets the widget values into the Part.
         */
        void setValues();

        // TSE3 objects
        TSE3::Phrase              *phrase;
        TSE3::Cmd::CommandHistory *history;

        // UI objects

        QFrame *phraseTab;
        QFrame *dparamsTab;

        PhraseWidget        *pwidget;
        DisplayParamsWidget *dpwidget;
};

#endif
