/*
 * @(#)Splash.h 1.00 9 November 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_SPLASH_H
#define ANTHEM_SPLASH_H

#include <qwidget.h>

/**
 * Anthem startup splash screen widget.
 *
 * @short   Splash screen widget
 * @author  Pete Goodliffe
 * @version 1.0
 */
class SplashScreen : public QWidget
{
        Q_OBJECT

    public:

        /**
         * Creates a splash screen and show() it. Its geometry is
         * set up to be central in the desktop.
         */
        SplashScreen();

        /**
         * Call this when you want the window to disappear. If the timeout
         * has happened then the window goes immediately.
         *
         * After you've called this, the window will delete itself at some
         * point, you cannot safely use the object again.
         */
        void disappear();

    private slots:

        void slotTimeout();

    private:

        bool canDisappear;
        bool timeout;
};

#endif
