/*
 * @(#)TSE3Progress.h 1.00 14 November 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_TSE3PROGRESS_H
#define ANTHEM_TSE3PROGRESSH

#include "tse3/Progress.h"

#include <qprogressdialog.h>

/**
 * A QProgressDialog that handles callbacks from the TSE3::Progress interface.
 *
 * @short   @ref TSE3::Progress @ref QProgressDialog
 * @author  Pete Goodliffe
 * @version 1.0
 */
class TSE3ProgressDialog : public QProgressDialog,
                           public TSE3::Progress
{
        Q_OBJECT

    public:

        /**
         * Creates the dialog - same parameters as
         * @ref QProgressDialog::QProgressDialog except for totalSteps - this
         * is calculated from the @ref TSE3::Progress event generator
         * and so doesn't need to be specified here.
         *
         * Don't forget that if you don't want a cancel button (with this
         * dialog, mostly you won't) specify @p cancelText as QString::null.
         */
        TSE3ProgressDialog(const QString &labelText, const QString &cancelText,
                           QWidget *creator = 0,
                           const char *name = 0, bool modal = FALSE,
                           WFlags f = 0);

        /**
         * @reimplemented
         */
        virtual void progressRange(int min, int max);

        /**
         * @reimplemented
         */
        virtual void progress(int value);

    private:

        int min;
        int max;
};

#endif
