/*
 * @(#)ColourPixmap.cpp 1.00 17 November 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "gadgets/ColourPixmap.h"

#include "Application.h"

#include "tse3/DisplayParams.h"

#include <qbitmap.h>
#include <qpainter.h>

void ColourPixmap::drawPixmap(QPixmap &pm, const QColor &c, int round)
{
    if (c != Qt::red)
    {
        pm.fill(Qt::red);
    }
    else
    {
        pm.fill(Qt::white);
    }
    {
        QPainter p(&pm);
        p.setPen(Qt::black);
        p.setBrush(c);
        p.drawRoundRect(0, 0, pm.width(), pm.height(), round, round);
    }
    pm.setMask(pm.createHeuristicMask());
}


QPixmap ColourPixmap::newPixmap(const QColor &c, int size, int round)
{
    QPixmap p(size, size);
    drawPixmap(p, c, round);
    return p;
}


QPixmap ColourPixmap::newPixmap(TSE3::DisplayParams &dp, int size, int round)
{
    if (dp.style() == TSE3::DisplayParams::Colour)
    {
        int r, g, b;
        dp.colour(r, g, b);
        return ColourPixmap::newPixmap(r, g, b);
    }
    else if (dp.style() == TSE3::DisplayParams::PresetColour)
    {
        int r, g, b;
        Application::application()->presetColours()->colour
            (dp.presetColour(), r, g, b);
        return ColourPixmap::newPixmap(r, g, b);
    }
    else
    {
        return ColourPixmap::newPixmap();
    }
}


QPixmap ColourPixmap::newPixmap(int size)
{
    QPixmap p(size, size);
    p.fill(Qt::white);
    p.setMask(p.createHeuristicMask());
    return p;
}

