/*
 * @(#)ColourPixmap.h 1.00 17 November 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_COLOURPIXMAP_H
#define ANTHEM_COLOURPIXMAP_H

#include <qpixmap.h>

namespace TSE3
{
    class DisplayParams;
}

namespace ColourPixmap
{
    const int pixmapSize  = 12;
    const int pixmapRound = 70;

    /**
     * Draws a colour swatch into a pixmap.
     */
    void drawPixmap(QPixmap &pm, const QColor &c,
                    int round = pixmapRound);

    /**
     * Creates a new QPixmap containing a colour swatch of the specified
     * colour.
     */
    QPixmap newPixmap(const QColor &c,
                      int size = pixmapSize, int round = pixmapRound);

    /**
     * Overloaded version of above function.
     */
    inline QPixmap newPixmap(int r, int g, int b,
                      int size = pixmapSize, int round = pixmapRound)
    {
        return newPixmap(QColor(r, g, b), size, round);
    }

    /**
     * Overloaded version of above function.
     */
    QPixmap newPixmap(TSE3::DisplayParams &dp,
                      int size = pixmapSize, int round = pixmapRound);

    /**
     * Creates a new QPixmap which is entirely empty.
     */
    QPixmap newPixmap(int size = pixmapSize);
}

#endif
