/*
 * @(#)FilteredKListView.cpp 1.00 22 May 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "gadgets/FilteredKListView.h"

#include <algorithm>

FilteredKListView::FilteredKListView(QWidget *parent, const char *name = 0)
: KListView(parent, name), lastClickIndex(-1)
{
    setMargins(0,0,0,horizontalScrollBar()->sizeHint().height());
    setSelectionMode(QListView::NoSelection);
}


void FilteredKListView::setSelectedWithoutSignal(QListViewItem *item, bool sel)
{
    item->setSelected(sel);
    repaintItem(item);
}


void FilteredKListView::contentsMousePressEvent(QMouseEvent *e)
{
    QListViewItem *item = itemAt(contentsToViewport(e->pos()));
    if (!item) return;
    setCurrentItem(item);
    int thisClickIndex = indexOf(item);

    if (e->button() & LeftButton)
    {
        if (e->state() & ShiftButton && lastClickIndex != -1)
        {
            QListViewItem *from = itemWithIndex(lastClickIndex);
            QListViewItem *to   = item;
            if (from)
            {
                if (lastClickIndex > thisClickIndex)
                {
                    std::swap(from, to);
                }
                emit wantToSelect(to, false);
                while (from != to)
                {
                    if (!from->isSelected())
                    {
                        emit wantToSelect(from, true);
                    }
                    from = from->nextSibling();
                }
            }
        }
        else if (item->isSelected() && (e->state() & ControlButton))
        {
            emit wantToClear(item);
        }
        else
        {
            emit wantToSelect(item, e->state() & ControlButton);
        }
    }
    lastClickIndex = indexOf(item);
    KListView::contentsMousePressEvent(e);
}


void FilteredKListView::clearSelection(QListViewItem *except)
{
    QListViewItem *item = firstChild();
    while (item)
    {
        if (item->isSelected() && item != except)
        {
            emit wantToClear(item);
        }
        item = item->nextSibling();
    }
}


size_t FilteredKListView::indexOf(QListViewItem *trackItem) const
{
    size_t index = 0;
    QListViewItem *i = firstChild();
    while (i != trackItem && i)
    {
        i = i->nextSibling();
        index++;
    }
    return index;
}


QListViewItem *FilteredKListView::itemWithIndex(size_t index) const
{
    QListViewItem *i = firstChild();
    while (index && i)
    {
        i = i->nextSibling();
        index--;
    }
    return i;
}

