/*
 * @(#)PartInsertActionWidget.cpp 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "gadgets/PartInsertActionWidget.h"

#include "tse3/cmd/Part.h"

/******************************************************************************
 * PartInsertActionWidget class
 *****************************************************************************/

const int PartInsertActionWidget::values[] =
{
    TSE3::Cmd::Part_Move::NoOverlap,
    TSE3::Cmd::Part_Move::Replace,
    TSE3::Cmd::Part_Move::Under
};


PartInsertActionWidget::PartInsertActionWidget(QWidget *parent,
                                               const char *name = 0)
: QComboBox(false, parent, name)
{
    setInsertionPolicy(NoInsertion);
    insertItem("No overlap");
    insertItem("Replace");
    insertItem("Under");

    connect(this, SIGNAL(activated(int)), SLOT(slotActivated(int)));
}


void PartInsertActionWidget::setValue(int mc)
{
    std::cout << "PartInsertActionWidget::setValue TODO\n";
}


void PartInsertActionWidget::slotActivated(int index)
{
    emit partInsertActionChanged(values[index]);
}

