/*
 * @(#)PartInsertActionWidget.h 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_GADGETS_PARTINSERTACTIONWIDGET_H
#define ANTHEM_GADGETS_PARTINSERTACTIONWIDGET_H

#include <qcombobox.h>

/**
 * This widget provides a button that can be used to choose a
 * @ref TSE3::Util::PartInsertAction value, either NoOverlap, Replace or Under.
 *
 * @short   @ref TSE3::Util::PartInsertAction value selection widget
 * @author  Pete Goodliffe
 * @version 1.0
 */
class PartInsertActionWidget : public QComboBox
{
        Q_OBJECT;

    public:

        PartInsertActionWidget(QWidget *parent, const char *name = 0);

        /**
         * Returns the @ref TSE3::MidiClock value of the current selection
         * or the Off/Bar value.
         */
        int value()
        {
            return values[currentItem()];
        }

        /**
         * Sets the current snap value.
         */
        void setValue(int pia);

    signals:

        /**
         * This signal is emitted when the combo box is changed. The
         * parameter value is a @ref TSE3::Util::PartInsertAction.
         */
        void partInsertActionChanged(int newValue);

    private slots:

        /**
         * Attached to activated signal - emits a partInsertActionChanged.
         */
        void slotActivated(int index);

    private:

        /**
         * Lookup table
         */
        static const int values[];
};

#endif
