/*
 * @(#)ZoomWidget.cpp 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "gadgets/ZoomWidget.h"

#include "misc/Interfaces.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qslider.h>

#include <kdialogbase.h>
#include <kiconloader.h>

/******************************************************************************
 * ZoomWidget class
 *****************************************************************************/

ZoomWidget::ZoomWidget(Zoomable *callback, QWidget *parent, const char *name)
: QWidget(parent, name), callback(callback)
{
    QGridLayout *layout
        = new QGridLayout(this, 2, 4, 0, KDialogBase::spacingHint());

    // Icons
    QLabel *label = new QLabel(this);
    label->setPixmap(UserIcon("icon_zoomhori"));
    layout->addWidget(label, 0, 0);
    label = new QLabel(this);
    label->setPixmap(UserIcon("icon_zoomvert"));
    layout->addWidget(label, 1, 0);

    // Sliders
    hori = new QSlider(0, 100, 10, 50, QSlider::Horizontal, this);
    layout->addWidget(hori, 0, 1);
    connect(hori, SIGNAL(valueChanged(int)), SLOT(horizontalChanged(int)));
    vert = new QSlider(0, 100, 10, 50, QSlider::Horizontal, this);
    layout->addWidget(vert, 1, 1);
    connect(vert, SIGNAL(valueChanged(int)), SLOT(verticalChanged(int)));
}


void ZoomWidget::showEvent(QShowEvent *event)
{

    hori->setValue(callback->zoomHorizontal());
    vert->setValue(callback->zoomVertical());
    QWidget::showEvent(event);
}


void ZoomWidget::zoomInHorizontal()
{
    callback->zoomInHorizontal();
}


void ZoomWidget::zoomOutHorizontal()
{
    callback->zoomOutHorizontal();
}


void ZoomWidget::zoomInVertical()
{
    callback->zoomInVertical();
}


void ZoomWidget::zoomOutVertical()
{
    callback->zoomOutVertical();
}


void ZoomWidget::horizontalChanged(int pc)
{
    callback->setZoomHorizontal(pc);
}


void ZoomWidget::verticalChanged(int pc)
{
    callback->setZoomVertical(pc);
}

