/*
 * @(#)main.cpp 1.00 5 July 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of Anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include <kapp.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <ktip.h>
#include <kstddirs.h>

#include "Application.h"
#include "songwindow/SongWindow.h"
#include "dialogues/Splash.h"
#include "gadgets/SystemTrayWidget.h"

#include "tse3/Error.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifndef VERSION
#define VERSION "[Not available]"
#endif

/**
 * Various program-info related definitions.
 */
namespace
{
    const char *description
        =I18N_NOOP("An open source MIDI sequencer.");

    const char *anthemText
        =I18N_NOOP("Anthem is a Trax Software product.\n"
                   "Visit the Anthem homepage to get the latest version "
                   "of Anthem.");

    const char *version = VERSION;

    KCmdLineOptions options[] =
    {
        { "stream",  I18N_NOOP("Use a StreamMidiScheduler that puts "
                               "all MIDI output in a window (used for "
                               "debugging Anthem"), 0 },
        { "alsa",    I18N_NOOP("Force an ALSA MidiScheduler"), 0 },
        { "oss",     I18N_NOOP("Force an OSS MidiScheduler"), 0 },
        { "+[file]", I18N_NOOP("File to open"), 0 },
        { 0, 0, 0}
    };
}


/**
 * The main Anthem main routine
 */
int anthem_main(int argc, char *argv[])
{
    Application::printStartupInfo();

    KAboutData aboutData("anthem", I18N_NOOP("Anthem"),
                         version, description, KAboutData::License_GPL,
                         "(c) 2000-2002, Pete Goodliffe", anthemText,
                         "http://anthem.sourceforge.net/",
                         "pete@cthree.org");
    aboutData.addAuthor("Pete Goodliffe", "Program author",
                        "pete@cthree.org",
                        "http://www.cthree.org/");

    KCmdLineArgs::init(argc, argv, &aboutData);
    KCmdLineArgs::addCmdLineOptions(options);

    Application       a;
    SplashScreen     *splash = new SplashScreen;
    SystemTrayWidget  tray;

    tray.show();

    if (a.isRestored())
    {
        RESTORE(SongWindow)
    }
    else
    {
        KTipDialog::showTip(locate("appdata", "tips"));

        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        for (int n = 0; n < args->count(); n++)
        {
            a.load(args->arg(n), args->arg(n));
        }
        if (!a.numSongs())
        {
            SongWindow* songWindow = new SongWindow();
            songWindow->show();
        }
        args->clear(); // free up some memory
    }

    splash->disappear();

    // TODO tip of the day?

    return a.exec();
}


/**
 * Program entry point. Runs anthem and catches any exceptions that make
 * it to the top.
 */
int main(int argc, char *argv[])
{
    try
    {
        return anthem_main(argc, argv);
    }
    catch (const TSE3::Error &e)
    {
        std::cerr << "TSE3 error detected: " << TSE3::errString(e.reason())
                  << std::endl;
    }
    catch (const std::exception &e)
    {
        std::cerr << "std exception detected\n";
    }
    return 1;
}

