/*
 * @(#)Interfaces.h 1.00 2 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_INTERFACES_H
#define ANTHEM_INTERFACES_H

/**
 * This interface is implemented by classes that can be 'zoomed'. It
 * is used by the @ref ZoomWidget as a callback interface.
 *
 * @short   Interface for widgets that can be zoomed
 * @author  Pete Goodliffe
 * @version 1.0
 */
class Zoomable
{

    public:

        /**
         * Returns the current horizontal zoom percentage (1-100).
         */
        virtual int zoomHorizontal() = 0;

        /**
         * Called by the @ref ZoomWidget when the Zoomable should alter the
         * horizontal zoom. The @p pc parameter is a percentaage value.
         */
        virtual void setZoomHorizontal(int pc) = 0;

        /**
         * Called by the @ref ZoomWidget when the Zoomable should zoom in
         * horizontally.
         */
        virtual void zoomInHorizontal() = 0;

        /**
         * Called by the @ref ZoomWidget when the Zoomable should zoom out
         * horizontally.
         */
        virtual void zoomOutHorizontal() = 0;

        /**
         * Returns the current vertical zoom percentage (1-100).
         */
        virtual int zoomVertical() = 0;

        /**
         * Called by the @ref ZoomWidget when the Zoomable should alter the
         * vertical zoom. The @p pc parameter is a percentaage value.
         */
        virtual void setZoomVertical(int pc) = 0;

        /**
         * Called by the @ref ZoomWidget when the Zoomable should zoom in
         * vertically.
         */
        virtual void zoomInVertical() = 0;

        /**
         * Called by the @ref ZoomWidget when the Zoomable should zoom out
         * vertically.
         */
        virtual void zoomOutVertical() = 0;
};

#endif
