/*
 * @(#)misc/KdeMidiScheduler.h 1.00 21 March 2001
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "misc/KdeMidiScheduler.h"

#include "misc/Streambuf.h"

#include "tse3/util/MidiScheduler.h"

#include "misc/kde2-compat.h"
#include <qtextview.h>
#include <kdialogbase.h>
#include <qlayout.h>
#include <kmessagebox.h>


/******************************************************************************
 * KdeMidiSchedulerWidget class
 *****************************************************************************/

class KdeMidiSchedulerWidget : public KDialogBase
{
    public:
        KdeMidiSchedulerWidget();
        virtual ~KdeMidiSchedulerWidget();
        std::ostream &ostream() { return *os; }
        virtual void slotUser1();
        virtual void slotUser2();
        virtual void slotUser3();
        virtual QSize sizeHint() const { return QSize(200, 200); }
    protected:
        virtual void closeEvent(QCloseEvent *e);
    private:
        QTextView                       *tv;
        QTextViewOStream                *os;
};


KdeMidiSchedulerWidget::KdeMidiSchedulerWidget()
: KDialogBase(Plain, "TSE3 MidiScheduler output", User1|User2|User3, User3,
              0, "KdeMidiSchedulerWidget", false, true,
              KGuiItem("Copy"), KGuiItem("Select all"), KGuiItem("Clear"))
{
    QVBoxLayout *layout = new QVBoxLayout(plainPage(), 0, spacingHint());

    tv  = new QTextView(plainPage());
    os  = new QTextViewOStream(*tv);

    layout->add(tv);
}


KdeMidiSchedulerWidget::~KdeMidiSchedulerWidget()
{
    delete os;
    delete tv;
}


void KdeMidiSchedulerWidget::slotUser1()
{
    tv->copy();
}


void KdeMidiSchedulerWidget::slotUser2()
{
    tv->selectAll();
}


void KdeMidiSchedulerWidget::slotUser3()
{
    tv->setText("");
}


void KdeMidiSchedulerWidget::closeEvent(QCloseEvent *e)
{
    if (KMessageBox::warningYesNo(this, "You can't reopen this window once it's closed.\nAre you sure you want to close it?") == KMessageBox::Yes)
    {
        e->accept();
    }
}


/******************************************************************************
 * KdeMidiSchedulerFactory class
 *****************************************************************************/

TSE3::MidiScheduler *KdeMidiSchedulerFactory::createScheduler()
{
    static KdeMidiSchedulerWidget *kmsw = new KdeMidiSchedulerWidget();
    static TSE3::Util::StreamMidiScheduler *sms
        = new TSE3::Util::StreamMidiScheduler(kmsw->ostream());

    kmsw->setMinimumSize(600,400);
    kmsw->show();

    return sms;
}

