/*
 * @(#)misc/KdeMidiScheduler.h 1.00 21 March 2001
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_KDEMIDISCHEDULER_H
#define ANTHEM_KDEMIDISCHEDULER_H

#include "tse3/MidiScheduler.h"

/**
 * A streambuf that takes the input from a C++ ostream, and places it into
 * a Qt @ref QString object.
 *
 * @short   C++ streambuf that directs output to a QString
 * @author  Pete Goodliffe
 * @version 1.0
 */
class KdeMidiSchedulerFactory : public TSE3::MidiSchedulerFactory
{
    public:
        virtual TSE3::MidiScheduler *createScheduler();
};

#endif
