/*
 * @(#)debug.cpp 1.00 30 May 2001
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "misc/debug.h"

#include <iostream>

unsigned int dbg::trace_function::depth = 0;

dbg::trace_function::trace_function(const char *fn_name)
: m_fn_name(fn_name)
{
    for (unsigned int n = 0; n < depth; n++) std::cerr << " ";
    depth++;
    std::cerr << "> " << m_fn_name << endl;
}

dbg::trace_function::~trace_function()
{
    depth--;
    for (unsigned int n = 0; n < depth; n++) std::cerr << " ";
    std::cerr << "< " << m_fn_name << endl;
}

