/*
 * @(#)Metronome.h 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_SETTINGS_METRONOME_H
#define ANTHEM_SETTINGS_METRONOME_H

#include "settings/SettingsWidget.h"

/******************************************************************************
 * Qt/KDE forward declarations
 *****************************************************************************/
class QCheckBox;
class QSpinBox;

/******************************************************************************
 * Anthem forward declarations
 *****************************************************************************/
class ClockWidget;
class KeyWidget;

/******************************************************************************
 * TSE3 forward declarations
 *****************************************************************************/
namespace TSE3
{
    class Metronome;
}


/**
 * This class provides a widget that alters a TSE3 @ref Metronome.
 *
 * @short   Metronome settings widget.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class MetronomeWidget : public SettingsWidget
{
    public:
        MetronomeWidget(TSE3::Metronome *m,
                        QWidget *parent, const char *name = 0);
        virtual ~MetronomeWidget();
        virtual void setValues();
        virtual void updateWidgets();
    private:
        TSE3::Metronome   *m;
        QSpinBox          *channel;
        QSpinBox          *port;
        ClockWidget       *duration;
        KeyWidget         *barNote;
        QSpinBox          *barVelocity;
        KeyWidget         *beatNote;
        QSpinBox          *beatVelocity;
        QCheckBox         *playing;
        QCheckBox         *recording;
};

#endif
