/*
 * @(#)Panic.h 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_SETTINGS_PANIC_H
#define ANTHEM_SETTINGS_PANIC_H

#include "settings/SettingsWidget.h"

class QCheckBox;
class QSpinBox;

class PortWidget;

namespace TSE3
{
    class Panic;
}

/**
 * An internal widget used by the @ref PanicWidget. This allows the user to
 * select a mask, used to set up GS resets and XG resets.
 *
 * @short   Panic ID mask widget.
 * @author  Pete Goodliffe
 * @version 1.0
 * @internal
 */
class IdMaskWidget : public QWidget
{
        Q_OBJECT

    public:

        /**
         * The mask has initial all bits set.
         */
        IdMaskWidget(int nobits, QWidget *parent, const char *name = 0);

        unsigned int mask() const { return _mask; }
        void setMask(unsigned int newMask);

    private slots:

        void slotSpin(int);
        void slotCheckBox();

    private:

        unsigned int  _mask;
        QSpinBox     *spin;
        QCheckBox    *check;
};


/**
 * This class provides a widget that alters a TSE3 @ref Panic.
 *
 * @short   Panic settings widget.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class PanicWidget : public SettingsWidget
{
        Q_OBJECT

    public:

        PanicWidget(TSE3::Panic *p, QWidget *parent, const char *name = 0);
        virtual ~PanicWidget();

        virtual void setValues();
        virtual void updateWidgets();

        /**
         * Places the current values into the specified object.
         */
        void setValues(TSE3::Panic &panic);

    private slots:

        void updateDisable();

    private:

        TSE3::Panic  *p;
        PortWidget   *port;
        QCheckBox    *status;
        QCheckBox    *midiReset;
        QCheckBox    *gmReset;
        QCheckBox    *gsReset;
        QCheckBox    *xgReset;
        IdMaskWidget *gsMask;
        IdMaskWidget *xgMask;
        QCheckBox    *allNotesOff;
        QCheckBox    *allNotesOffManually;
        QCheckBox    *allModsOff;
        QCheckBox    *allPitchOff;
        QCheckBox    *allCtrlOff;
        QCheckBox    *liftSustain;
};

#endif
