/*
 * @(#)Part.cpp 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */


#include "settings/Part.h"

#include "tse3/kdeui/ClockWidget.h"
#include "gadgets/PhraseSelectWidget.h"

#include <qlabel.h>
#include <qlayout.h>

#include <kdialogbase.h>

#include "tse3/Song.h"
#include "tse3/Part.h"

/******************************************************************************
 * PartWidget class
 *****************************************************************************/

PartWidget::PartWidget(TSE3::Part *p, TSE3::Song *song,
                       QWidget *parent, const char *name)
: SettingsWidget(new SettingsImpl<TSE3::PartListener>(p), parent, name), p(p)
{
    QVBoxLayout *layout = new QVBoxLayout(this, KDialogBase::spacingHint(), -1);
    QGridLayout *gl = new QGridLayout(layout, 1, 2);

    // Phrase
    QLabel *label = new QLabel("Phrase", this);
    label->setAlignment(AlignRight|AlignVCenter);
    label->setMaximumSize(label->sizeHint());
    gl->addWidget(label, 0, 0);
    phraseSelect = new PhraseSelectEditWidget(song->phraseList(), true,
                                              p->phrase(), song, this);
    gl->addWidget(phraseSelect, 0, 1);

    // Repeat
    label = new QLabel("Repeat", this);
    label->setMaximumSize(label->sizeHint());
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 1, 0);
    _repeat = new ClockWidget(this, false);
    _repeat->setSpecialValueText("Off");
    gl->addWidget(_repeat, 1, 1);

    layout->addStretch(1);
    updateWidgets();
}


PartWidget::~PartWidget()
{
}


void PartWidget::setValues()
{
    p->setPhrase(phraseSelect->phrase());
    p->setRepeat(_repeat->value());
}


TSE3::Phrase *PartWidget::phrase()
{
    return phraseSelect->phrase();
}


TSE3::Clock PartWidget::repeat()
{
    return _repeat->value();
}


void PartWidget::updateWidgets()
{
    phraseSelect->setPhrase(p->phrase());
    _repeat->setValue(p->repeat());
}

