/*
 * @(#)Plugins.h 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_SETTINGS_PLUGINS_H
#define ANTHEM_SETTINGS_PLUGINS_H

#include "settings/SettingsWidget.h"

class QListBox;
class QPushButton;

class ClockWidget;

/**
 * This class provides a widget that alters the application plugins.
 * It manipulates the @ref ApplicationPlugins object.
 *
 * @short   Plugins settings widget.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class PluginsWidget : public SettingsWidget
{
        Q_OBJECT;
    public:
        PluginsWidget(QWidget *parent, const char *name = 0);
        virtual ~PluginsWidget();
        virtual void setValues();
        virtual void updateWidgets();
    private slots:
        void slotSelectionChanged();
        void slotAdd();
        void slotDelete();
        void slotUp();
        void slotDown();
    private:
        void updateButtons();
        QListBox    *loaded;
        QListBox    *directories;
        QPushButton *b_add;
        QPushButton *b_delete;
        QPushButton *b_up;
        QPushButton *b_down;
        int          selection;
};

#endif
