/*
 * @(#)PresetColours.cpp 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "settings/PresetColours.h"

#include "Application.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qscrollview.h>

#include <kdialogbase.h>
#include <kcolorbtn.h>

#include "tse3/DisplayParams.h"

/******************************************************************************
 * PresetColoursWidget class
 *****************************************************************************/

PresetColoursWidget::PresetColoursWidget(QWidget *parent, const char *name)
: SettingsWidget
    (new SettingsImpl<TSE3::PresetColoursListener>
         (Application::application()->presetColours()),
     parent, name)
{
    QVBoxLayout *layout = new QVBoxLayout(this, KDialogBase::spacingHint(), -1);

    QScrollView *sv = new QScrollView(this);
    layout->addWidget(sv);
    QWidget *widget = new QWidget(sv->viewport());
    sv->addChild(widget);
    sv->setResizePolicy(QScrollView::AutoOneFit);
    QGridLayout *gl = new QGridLayout(widget, 8,
                                      TSE3::DisplayParams::NoPresetColours/3,
                                      KDialogBase::spacingHint(), -1);
    gl->setColStretch(0, 10);
    gl->setColStretch(7, 10);

    buttons = new KColorButton*[TSE3::DisplayParams::NoPresetColours];
    for (size_t n = 0; n < TSE3::DisplayParams::NoPresetColours; n++)
    {
        int r, g, b;
        Application::application()->presetColours()->colour(n, r, g, b);

        QLabel *label = new QLabel(TSE3::DisplayParams::presetColourString(n),
                                   widget);
        buttons[n]    = new KColorButton(QColor(r, g, b), widget);
        connect(buttons[n], SIGNAL(changed(const QColor &)),
                SLOT(slotColourChanged(const QColor &)));

        const int height = (TSE3::DisplayParams::NoPresetColours/3)
                         + (TSE3::DisplayParams::NoPresetColours%3 != 0);
        int x = n/height;
        int y = n - (x*height);
        x *= 2;
        x += 1;
        gl->addWidget(label,      y, x);
        gl->addWidget(buttons[n], y, x+1);
    }

    layout->addStretch(1);
    updateWidgets();
}


PresetColoursWidget::~PresetColoursWidget()
{
    delete buttons;
}


void PresetColoursWidget::slotColourChanged(const QColor &)
{
    altered = true;
}


void PresetColoursWidget::setValues()
{
    if (altered)
    {
        for (size_t n = 0; n < TSE3::DisplayParams::NoPresetColours; n++)
        {
            int r, g, b;
            buttons[n]->color().rgb(&r, &g, &b);
            Application::application()->presetColours()->setColour(n, r, g, b);
        }
        altered = false;
    }
}


void PresetColoursWidget::updateWidgets()
{
    for (size_t n = 0; n < TSE3::DisplayParams::NoPresetColours; n++)
    {
        int r, g, b;
        Application::application()->presetColours()->colour(n, r, g, b);
        buttons[n]->setColor(QColor(r, g, b));
    }
    altered = false;
}
