/*
 * @(#)PresetColours.h 1.00 17 November 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_SETTINGS_PRESETCOLOURS_H
#define ANTHEM_SETTINGS_PRESETCOLOURS_H

#include "settings/SettingsWidget.h"

class KColorButton;

/**
 * This class provides a widget that alters the global @ref TSE3::PresetColours
 * object.
 *
 * @short   PresetColours settings widget.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class PresetColoursWidget : public SettingsWidget
{
        Q_OBJECT

    public:

        PresetColoursWidget(QWidget *parent, const char *name = 0);
        virtual ~PresetColoursWidget();
        virtual void setValues();
        virtual void updateWidgets();

    private slots:

        void slotColourChanged(const QColor &);

    private:

        KColorButton **buttons;
        bool           altered;
};

#endif
