/*
 * @(#)SettingsWidget.cpp 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "settings/SettingsWidget.h"

/******************************************************************************
 * AbstractSettingsImpl class
 *****************************************************************************/

AbstractSettingsImpl::~AbstractSettingsImpl()
{
}


/******************************************************************************
 * SettingsWidget class
 *****************************************************************************/

SettingsWidget::SettingsWidget(AbstractSettingsImpl *impl,
                               QWidget *parent, const char *name)
: QFrame(parent, name), impl(impl)
{
}


SettingsWidget::~SettingsWidget()
{
    delete impl;
}


void SettingsWidget::accept()
{
    if (impl) impl->preSetValues();
    setValues();
    if (impl) impl->postSetValues();
}
