/*
 * @(#)Track.h 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_SETTINGS_TRACK_H
#define ANTHEM_SETTINGS_TRACK_H

#include "settings/SettingsWidget.h"

/******************************************************************************
 * Qt/KDE forward declarations
 *****************************************************************************/
class QLabel;
class QLineEdit;

/******************************************************************************
 * TSE3 forward declarations
 *****************************************************************************/
namespace TSE3
{
    class Track;
}

/**
 * This class provides a widget that alters a TSE3 @ref Track.
 *
 * @short   Track settings widget.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class TrackWidget : public SettingsWidget
{
    public:
        TrackWidget(TSE3::Track *t, QWidget *parent, const char *name = 0);
        virtual ~TrackWidget();
        virtual void setValues();
        virtual void updateWidgets();
        const QString title();
    private:
        TSE3::Track *t;
        QLineEdit   *titleEdit;
        QLabel      *noParts;

};

#endif
